<?xml version="1.0" encoding="utf-8" ?> 

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>



	<xsl:include href="../../apt/views/multisectionspreadsheet.xslt"/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>



	<xsl:variable name="totalTime" select="sum(//*[@type='snapshotentry'][1]/*[@type='profilernode']/@functimer)"/>



	<xsl:template match='*[@type="snapshotentry"]'>

		<xsl:call-template name="multisection_start">

			<xsl:with-param name="sections">

				<section name="snapshot_desc"><xsl:copy-of select="*[@type='snapshotdesc']"/></section>

				<section name="appliedTriggers"><xsl:copy-of select="triggers[1]"/></section>

				<section name="snapshot"><xsl:copy-of select="."/></section>

			</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="section_title">

		<xsl:param name="section_name"/>

		<xsl:choose>

			<xsl:when test="string($section_name) = 'snapshot_desc'">

				Snapshot Detail

			</xsl:when>

			<xsl:when test="string($section_name) = 'snapshot'">Function List</xsl:when>

			<xsl:when test="string($section_name) = 'appliedTriggers'">Triggers Applied</xsl:when>

		</xsl:choose>

	</xsl:template>

	

	<xsl:template name="section_content">

		<xsl:param name="section_name"/>

		<xsl:choose>

			<xsl:when test="string($section_name) = 'snapshot_desc'">

				<table class="snapshot_description" cellpading="0" cellspacing="0">

					<tr>

						<td class="snapshot_description_field">Start Time</td>

						<td class="snapshot_description_value">

							<xsl:value-of select="string(*[@id='starttime']/@value)"/>

						</td>

					</tr>

					<tr>

						<td class="snapshot_description_field">End Time</td>

						<td class="snapshot_description_value">

							<xsl:value-of select="string(*[@id='endtime']/@value)"/>

						</td>

					</tr>

					<tr>

						<td class="snapshot_description_field">Timer Resolution</td>

						<td class="snapshot_description_value">

							<xsl:value-of select="string(*[@id='resolution']/@value)"/>

						</td>

					</tr>

					<tr>

						<td class="snapshot_description_field">Start URL</td>

						<td class="snapshot_description_value">

							<xsl:value-of select="string(*[@id='starturl']/@value)"/>

						</td>

					</tr>

				</table>

			</xsl:when>

			<xsl:when test="string($section_name) = 'snapshot'">

				<div class="snapshotcontainer">

					<xsl:for-each select="./*[1]">

						<xsl:call-template name="spreadsheet_start">

							<xsl:with-param name="name">funclist</xsl:with-param>

							<xsl:with-param name="autofit_minheight">100</xsl:with-param>

						</xsl:call-template>

					</xsl:for-each>

				</div>

			</xsl:when>

			<xsl:when test="string($section_name) = 'appliedTriggers'">

				<div class="triggerscontainer">

					<xsl:for-each select="./*[1]">

						<xsl:call-template name="spreadsheet_start">

							<xsl:with-param name="name">triggers</xsl:with-param>

							<xsl:with-param name="fit_height">true</xsl:with-param>

						</xsl:call-template>

					</xsl:for-each>

				</div>

			</xsl:when>

		</xsl:choose>

	</xsl:template>

	

	<xsl:template name="spreadsheet_columns_def">

		<xsl:param name="hidden"/>

		<xsl:param name="sheet"/>

		<xsl:choose>

			<xsl:when test="$sheet = 'funclist'">

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Function</xsl:with-param>

					<xsl:with-param name="width">80px</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Count</xsl:with-param>

					<xsl:with-param name="width">60px</xsl:with-param>

					<xsl:with-param name="type">number</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Function Time</xsl:with-param>

					<xsl:with-param name="width">100px</xsl:with-param>

					<xsl:with-param name="type">number</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Culmulative Time</xsl:with-param>

					<xsl:with-param name="width">100px</xsl:with-param>

					<xsl:with-param name="type">number</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">URL</xsl:with-param>

					<xsl:with-param name="width">100%</xsl:with-param>

					<xsl:with-param name="minwidth">200px</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

			</xsl:when>

			<xsl:when test="$sheet = 'triggers'">

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Profiler Event</xsl:with-param>

					<xsl:with-param name="width">80px</xsl:with-param>

					<xsl:with-param name="fixedPos">true</xsl:with-param>

					<xsl:with-param name="sortable">false</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">URL</xsl:with-param>

					<xsl:with-param name="width">140px</xsl:with-param>

					<xsl:with-param name="fixedPos">true</xsl:with-param>

					<xsl:with-param name="sortable">false</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Function Name</xsl:with-param>

					<xsl:with-param name="width">80px</xsl:with-param>

					<xsl:with-param name="fixedPos">true</xsl:with-param>

					<xsl:with-param name="sortable">false</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Object</xsl:with-param>

					<xsl:with-param name="width">80px</xsl:with-param>

					<xsl:with-param name="fixedPos">true</xsl:with-param>

					<xsl:with-param name="sortable">false</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Event</xsl:with-param>

					<xsl:with-param name="width">80px</xsl:with-param>

					<xsl:with-param name="fixedPos">true</xsl:with-param>

					<xsl:with-param name="sortable">false</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Timer</xsl:with-param>

					<xsl:with-param name="width">80px</xsl:with-param>

					<xsl:with-param name="type">number</xsl:with-param>

					<xsl:with-param name="fixedPos">true</xsl:with-param>

					<xsl:with-param name="sortable">false</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_column">

					<xsl:with-param name="name">Action</xsl:with-param>

					<xsl:with-param name="width">80px</xsl:with-param>

					<xsl:with-param name="fixedPos">true</xsl:with-param>

					<xsl:with-param name="sortable">false</xsl:with-param>

					<xsl:with-param name="hidden" select="$hidden"/>

				</xsl:call-template>

			</xsl:when>

		</xsl:choose>

	</xsl:template>

	

	<xsl:template name="spreadsheet_rows_def">

		<xsl:param name="hidden"/>

		<xsl:param name="sheet"/>

		<xsl:choose>

			<xsl:when test="$sheet = 'funclist'">

				<xsl:for-each select='node()[@type="profilernode"]'>

					<xsl:call-template name="spreadsheet_row">

						<xsl:with-param name="hidden" select="$hidden"/>

						<xsl:with-param name="sheet" select="$sheet"/>

					</xsl:call-template>

				</xsl:for-each>

			</xsl:when>

			<xsl:when test="$sheet = 'triggers'">

				<xsl:for-each select='profilertrigger'>

					<xsl:call-template name="spreadsheet_row">

						<xsl:with-param name="hidden" select="$hidden"/>

						<xsl:with-param name="sheet" select="$sheet"/>

					</xsl:call-template>

				</xsl:for-each>

			</xsl:when>

		</xsl:choose>

	</xsl:template>

	

	<xsl:template name="spreadsheet_values_def">

		<xsl:param name="sheet"/>

		<xsl:choose>

			<xsl:when test="$sheet = 'funclist'">

				<xsl:attribute name="statementid">

					<xsl:value-of select="@statementid"/>

				</xsl:attribute>

				<xsl:attribute name="functimerper">

					<xsl:value-of select="round(@functimer*10000 div $totalTime) div 100"/>

				</xsl:attribute>

				<xsl:attribute name="cultimerper">

					<xsl:value-of select="round(@cultimer*10000 div $totalTime) div 100"/>

				</xsl:attribute>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@funcname)"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@count)"/>

					<xsl:with-param name="type">number</xsl:with-param>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="concat(string(@functimer),' (',round(@functimer*10000 div $totalTime) div 100,'%)')"/>

					<xsl:with-param name="type">number</xsl:with-param>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="concat(string(@cultimer),' (',round(@cultimer*10000 div $totalTime) div 100,'%)')"/>

					<xsl:with-param name="type">number</xsl:with-param>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value"><a href='javascript:' class='titoAnchor'><xsl:value-of select="@codebase"/></a></xsl:with-param>

				</xsl:call-template>

			</xsl:when>

			<xsl:when test="$sheet = 'triggers'">

				<xsl:attribute name="profilertriggerid">

					<xsl:value-of select="@id"/>

				</xsl:attribute>

				<xsl:attribute name="profilertriggereventtype">

					<xsl:value-of select="@profilerevent"/>

				</xsl:attribute>

			

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@profilerevent)"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@codebase)"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@funcname)"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@object)"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@event)"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@timer)"/>

				</xsl:call-template>

				<xsl:call-template name="spreadsheet_value">

					<xsl:with-param name="value" select="string(@action)"/>

				</xsl:call-template>

			</xsl:when>

		</xsl:choose>

	</xsl:template>



</xsl:stylesheet>

